<?php
/**
 * The template used for displaying Test Questions
 * @package unified-quiz-maker
 */
if (!defined('ABSPATH'))
{
    die("Access denied!");
}
if (!defined('HTQ_SLUG'))
{
    wp_die(__("Please install the Unified Quiz Maker plugin.", 'htq'), __('Error', 'htq'));
}

global $post;
$user_id            = get_current_user_id();
$user               = wp_get_current_user();
/**
 * The header for our theme
 */
?> <!DOCTYPE html>
<html itemscope itemtype="http://schema.org/WebPage" <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
        <?php do_action('studiare_before_body'); ?>
        <?php
        $header_button      = true;
        $header_button_link = 'account';
        $account_link       = get_permalink(get_option('woocommerce_myaccount_page_id'));

        if (class_exists('Redux'))
        {
            $header_button      = codebean_option('header_button');
            $header_button_link = codebean_option('header_button_link');
        }
        ?>

        <?php if (( $header_button ) && ( $header_button_link == 'account' )) : ?>
            <div class="modal">
                <div class="login-form-overlay"></div>
                <div class="login-form-modal">
                    <div class="login-form-modal-inner">
                        <div class="login-form-modal-box">
                            <a href="javascript:void(0)" class="close">
                                <?php get_template_part('/assets/images/close-icon.svg'); ?>
                            </a>
                            <div class="login-form-header">
                                <h3 class="login-title"><?php esc_html_e('Sign In', 'studiare'); ?></h3>
                            </div>
                            <div class="login-form-content">
                                <?php get_template_part('/inc/templates/login-modal'); ?>
                                <?php
                                printf(
                                        esc_html__('Not a member yet? %1$sSign Up%2$s', 'studiare'),
                                        '<a href="' . esc_url($account_link) . '"><strong>',
                                        '</strong></a>'
                                );
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="wrap">

            <?php if (studiare_needs_header()): ?>

                <?php get_template_part('/inc/templates/header/top-bar'); ?>
                <?php get_template_part('/inc/templates/header/header-main'); ?>
            <?php endif; ?>

            <div id="page" class="site htq_class">
                <div class="inner-wrapper">
                    <div id="content" class="site-content">
                        <div class="container">
                            <div id="primary" class="content-area-quiz">
                                <main id="main" class="site-main site-content-inner vc-container" role="main">
                                    <div class="row">
                                        <div class="col-md-10 htq_test_col">
                                            <div class="post-wrapper">
                                                <div class="row">
                                                    <div id="run_<?php echo get_the_ID() ?>" class="col-md-12">
                                                        <?php
                                                        $errors     = array();
                                                        $err_status = false;

                                                        $test_obj = $post;
                                                        $test_id  = $test_obj->ID;
                                                        if ($test_id)
                                                        {
                                                            $result = htq_start_test_step($test_id);

                                                            $errors              = $result['errors'];
                                                            $err_status          = $result['err_status'];
                                                            $all_books           = $result['all_books'];
                                                            $questions_list      = $result['questions_list'];
                                                            $time_in_second      = $result['time_in_second'];
                                                            $all_questions_count = $result['all_questions_count'];
                                                            $allowed_run         = $result['allowed_run'];
                                                            $run_count           = $result['run_count'];

                                                            // limit info
                                                            $limit_info = get_test_limit_info($test_obj->ID);
                                                            if ($err_status == false)
                                                            {

                                                                if (!is_array($limit_info))
                                                                {
                                                                    $limit_info = array();
                                                                }
                                                                //check date limit
                                                                $limit_status = is_isset($limit_info, 'test_limit');
                                                                if (intval($limit_status) == 1)
                                                                {
                                                                    $start_date = is_isset($limit_info, 'test_limit_start');
                                                                    $end_date   = is_isset($limit_info, 'test_limit_end');

                                                                    if (strtotime($start_date) > strtotime(current_time('mysql')))
                                                                    {
                                                                        delete_user_meta($user_id, 'test_' . $test_id);
                                                                        $errors[]   = '';
                                                                        $err_status = true;

                                                                        $output = htq_start_test_step_limit($start_date, $test_id);

                                                                        echo $output;
                                                                    }
                                                                    elseif (strtotime(current_time('mysql')) > strtotime($end_date))
                                                                    {
                                                                        ob_start();
                                                                        ?>
                                                                        <p>
                                                                            <?php
                                                                            $errors[]   = htq_show_message(__('Test date has expired!', 'htq'), __('Error!', 'htq'), 'warning');
                                                                            $err_status = true;
                                                                            ?>
                                                                        </p>
                                                                        <?php
                                                                        $output     = ob_get_clean();

                                                                        echo $output;
                                                                    }
                                                                }


                                                                if ($err_status == false)
                                                                {
                                                                    // timer countdown
                                                                    $all_seconds = $time_in_second;

                                                                    $timer_reasult = htq_start_test_step_timer($test_id, $all_questions_count, $all_seconds);

                                                                    $array_metas  = $timer_reasult['array_meta'];
                                                                    $last_test_id = $timer_reasult['last_test_id'];

                                                                    //Get the current timestamp.
                                                                    $now              = time();
                                                                    //Calculate how many seconds have passed since
                                                                    //the countdown began.
                                                                    $timeSince        = $now - $array_metas['time_started'];
                                                                    $remainingSeconds = ($array_metas['countdown'] - $timeSince);

                                                                    //Check if the countdown has finished.
                                                                    if ($remainingSeconds < 1)
                                                                    {
                                                                        //Finished! Do something.
                                                                    }

                                                                    ob_start();
                                                                    ?>
                                                                    <script type="text/javascript">
                                                                        jQuery(document).ready(function ()
                                                                        {
                                                                            window.history.pushState(null, "", window.location.href);
                                                                            window.onpopstate = function () {
                                                                                window.history.pushState(null, "", window.location.href);
                                                                            };
                                                                            htq_clock(<?php echo $remainingSeconds; ?>);
                                                                        });
                                                                    </script>
                                                                    <div class="htq_all_questions htq_class">

                                                                        <?php
                                                                        $test_result_link = htq_get_page('test_result');
                                                                        global $is_test_template;
                                                                        if (!isset($is_test_template))
                                                                        {
                                                                            unset($is_test_template);
                                                                            if (!isset($param_shortcode['id']))
                                                                            {
                                                                                ?>
                                                                                <haeder class="htq_book_name">
                                                                                    <h3 style="text-align: center" class="htq_name">برگزاری آزمون</h3>
                                                                                    <h2 class="htq_name"><?php echo $post->post_title ; ?></h2>
                                                                                </haeder>
                                                                                <?php
                                                                            }
                                                                        }
                                                                        ?>
                                                                        <form id="htq_questions_form" method="POST" action="<?php echo add_query_arg(array('test_id' => $test_id), $test_result_link); ?>">
                                                                            <input name="action" type="hidden" value="htq_test_run" />
                                                                            <input name="test_id" type="hidden" value="<?php echo $post->ID ?>" /> 

                                                                            <?php
                                                                            foreach ($all_books as $book)
                                                                            {
                                                                                $direction      = $book->direction;
																				if( $direction == 1)
																				{
																					$direction_name = 'rtl';
																				}
																				elseif($direction == 2)
																				{
																					 $direction_name = 'ltr';
																				}
																				else
																				{
																				   $direction_name = 'inherit'; 
																				}
                                                                                ?>
                                                                                <div class="books_container">

                                                                                    <div class="book-title clearfix"> 
                                                                                        <i class="icon-book" aria-hidden="true"></i>
                                                                                        <div class="book-title">
                                                                                            <h3><?php echo $book->Name ?></h3>
                                                                                        </div>
                                                                                    </div>
                                                                                    <style type="text/css">

                                                                                        .htq_questions_table
                                                                                        {
                                                                                            <?php
                                                                                            if ($direction == 1)
                                                                                            {
                                                                                                $direction2 = 'direction: rtl; text-align: right;';
                                                                                            }
                                                                                            elseif ($direction == 2)
                                                                                            {
                                                                                                $direction2 = 'direction: ltr; text-align: left;';
                                                                                            }
                                                                                            ?>

                                                                                        }
                                                                                        html[lang="fa-IR"] .style1 .checkmark
                                                                                        {
                                                                                                right: 0 !important;
                                                                                                left: unset !important;
                                                                                        } 
                                                                                        html .style2 .checkmark
                                                                                        {
                                                                                                right: unset !important;
                                                                                                left:0 !important;
                                                                                        } 
                                                                                    </style>
                                                                                    <table class="htq_questions_table style<?php echo $direction ?>" style="direction: <?php echo $direction_name . '; ' . $direction2 ?>">

                                                                                        <?php
                                                                                        $index = 0;
                                                                                        foreach ($questions_list['book_' . $book->id] as $question)
                                                                                        {
                                                                                            $index++;
                                                                                            htq_draw_question($question, $index, $post->ID, $book->id);
                                                                                        }
                                                                                        ?>
                                                                                    </table>
                                                                                </div>
                                                                                <?php
                                                                            }
                                                                            $answord = 0;
                                                                            ?>
                                                                            <p>&nbsp;</p>
                                                                            <br>

                                                                            <div class="htq_btn_bar_floating">

                                                                                <div title="<?php _e('Number of questions and answers', 'htq'); ?>" class="actionbutton btn btn-success htq_qans htq_br-4">
                                                                                    <i class="fa fa-check-circle" aria-hidden="true"> </i>
                                                                                    <label id="htq_qans_lbl"><?php echo printf(__('%s out of %s', 'htq'), $answord, $all_questions_count) ?></label>
                                                                                </div>

                                                                                <div class="actionbutton btn btn-primary htq_br-4">
                                                                                    <i class="fa fa-user-circle" aria-hidden="true"> </i><?php echo $user->user_firstname . ' ' . $user->user_lastname ?>
                                                                                </div>

                                                                                <div class="actionbutton htq_timer">
                                                                                    <i class="fa fa-clock-o" aria-hidden="true"></i>
                                                                                    <label id="htq_timer_lbl">00:00:00</label>
                                                                                </div>

                                                                                <button id="htq_submit_test" type="button" class="actionbutton btn btn-filled btn-submit"><i class="fa fa-check" aria-hidden="true"></i>
                                                                                    <?php _e('Final Submit', 'htq'); ?>
                                                                                </button>

                                                                            </div>

                                                                        </form>

                                                                    </div>
                                                                    <?php
                                                                    $output  = ob_get_clean(); //Get current buffer contents and delete current output buffer
                                                                }
                                                            }
                                                            if (count($errors) == 0)
                                                            {
                                                                $check_num = get_run_test_count($user_id, $test_id, 0);

                                                                if (intval($check_num) == 0 || (intval($run_count) <= $allowed_run || $allowed_run == -1))
                                                                {
                                                                    $last_res_id = htq_add_new_parent_result($user_id, $test_id);
                                                                }

                                                                echo htq_start_test_step_qu_chk_js($test_id, $all_questions_count);
                                                                echo do_shortcode($output);
                                                            }
                                                            else
                                                            {
                                                                echo $errors[0];
                                                                echo '<p><br><br></p>';
                                                            }
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                            </div><!--post-wrapper-->
                                        </div>
                                    </div>
                                </main><!-- #main -->
                            </div><!-- #primary -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php		
$back_to_top = true;

if ( class_exists('Redux')) {
    $footer_visiblity = codebean_option('footer_visibility');
	$footer_waves_visiblity = codebean_option('footer_waves_visiblity');
    $footer_widgets_opt = codebean_option('footer_widgets');
    $footer_color_scheme = codebean_option('footer_color_scheme');
	$footer_coyprights_opt = codebean_option('disable_copyrights');
	$back_to_top = codebean_option('scroll_top_btn');
}
?>
<?php if ( $back_to_top ) : ?>
    <a id="back-to-top" class="back-to-top">
        <i class="material-icons">keyboard_arrow_up</i>
    </a>
<?php endif; ?>
<?php wp_footer(); ?>
</body>
</html>
        